function [b]=udppeek(skt,add,len)
%function [b]=udppeek(skt,add,len)
% Low level wrapper for udppeekb to extend peeking bytes
% past the udp packet length limit
% updated for octave 27-Feb-2018 - Ian Stothers
% updated for compatibility with 32 bit mcu octave 25/may/2020 - Ian Stothers
% updated to ensure only requested packet size appended to binary data
% 19-Dec- 2022 - Ian Stothers
%Serial bits added
% 6-June- 2023 - Ian Stothers
global UDP_RX_ERRORS;
if (min(size(UDP_RX_ERRORS))==0)
  UDP_RX_ERRORS=0;
endif
if (ischar(skt)==1)
   skt=sktopen(skt);
endif
if (isfield(skt,'ser')==1)
  [b]=serpeek(skt,add,len);
  return;
endif

if (skt.bits==16)
  [b]=udppeek16(skt,add,len);
  return;
endif
b=[];

oklim=10;
op=[];
pp_commands;
while (len>0)
     toget=min([len skt.max]);
     ok=oklim;  % Allow retry
     while (ok>0)
      pbuf=uint8([UDP_PEEK bitand(toget,255) bitand(floor(toget/2.^8),255) bitand(floor(toget/2.^16),255) bitand(floor(toget/2.^24),255)...
      bitand(add,255) bitand(floor(add/2.^8),255) bitand(floor(add/2.^16),255) bitand(floor(add/2.^24),255) ]);
       try
        flushinput(skt.udp);
        write(skt.udp,pbuf,skt.ip,skt.port);
        flushoutput(skt.udp);
        flushinput(skt.udp);
        bb=double(read(skt.udp,PHSIZE+toget));
        if (size(bb)(2)==(PHSIZE+toget))
         if ((bb(1:4)==UDP_PEEK_REPLY)&&((toget+PHSIZE)==size(bb)(2)))
           ok=-1;
           op=bb((1+PHSIZE):size(bb)(2));

           b=[b op];
           len=len-toget;
           add=add+toget;
         end
        end
      catch
      end
      if (ok==0)
        error(['udppeek retry time-out contacting '  skt.ip]);
        UDP_RX_ERRORS=UDP_RX_ERRORS+1;
      endif
      ok=ok-1;
      if(ok>0)
       pause(0.005*(oklim-ok));
      end 
     end  %while ok
    end %while len
endfunction

function [b]=udppeek16(skt,add,len)
%function [b]=udppeek16(skt,add,len)
% Low level wrapper for udppeekb to extend peeking bytes
% past the udp packet length limit
% updated for octave 27-Feb-2018 - Ian Stothers
% updated for compatibility with 32 bit mcu octave 25/may/2020 - Ian Stothers
b=[];
PHSIZE=6;
%Get the data
 flushinput(skt.udp);
 while (len>0)
      toget=min([len skt.max]);
      ok=3;  % Allow 2 retry
      while (ok>0)
       pbuf=uint8([3 0 0 0 bitand(toget,255) floor(toget/256.0) bitand(add,255) floor(add/256.0) ]);
       try
        flushinput(skt.udp);
        write(skt.udp,pbuf,skt.ip,skt.port);
        flushoutput(skt.udp);
        bb=double(read(skt.udp,PHSIZE+toget));
        if (max(size(bb))==PHSIZE+toget)
         if ((bb(1:4)==[ 4 0 0 0])&&((bb(5)+(bb(6)*256)+PHSIZE)==max(size(bb))))
           ok=-1;
           op=bb((1+PHSIZE):max(size(bb)));
         end
        end
       catch;
       end_try_catch
       ok=ok-1;
      end
      if (ok==0)
          error(['Retry time-out contacting '  sprintf('%s',get(skt.udp,'remotehost'))])
      end
      b=[b op];
      len=len-toget;
      add=add+toget;
 end
endfunction

function [b]=serpeek(skt,add,len)
%function [b]=serpeek(skt,add,len)
% updated for octave 27-Feb-2018 - Ian Stothers
% updated for compatibility with 32 bit mcu octave 25/may/2020 - Ian Stothers
% updated to ensure only requested packet size appended to binary data
% 6-June- 2023 - Ian Stothers

pp_commands;
b=[];

op=[];
 while (len>0)
      toget=min([len skt.max]);
      pbuf=uint8([UDP_PEEK bitand(toget,255) ...
      bitand(add,255) bitand(floor(add/2.^8),255) bitand(floor(add/2.^16),255) bitand(floor(add/2.^24),255) ]);
      bb=sersendget(skt,pbuf,PPHSIZE+toget);
      if (max(size(bb))==PPHSIZE+toget)
        if ((bb(1:4)==[UDP_PEEK_REPLY])&&(toget==bb(5))&&(max(size(bb))>=(PPHSIZE+toget)))

           op=bb((PPHSIZE)+(1:bb(5)));

           b=[b op];
           len=len-toget;
           add=add+toget;
        end
       end


 end %while len
endfunction

